/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.mixin;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.api.IllusionerEntityAccess;
import com.faboslav.friendsandfoes.mixin.BlindTargetGoalFactory;
import com.faboslav.friendsandfoes.util.RandomGenerator;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={Illusioner.class})
public abstract class IllusionerEntityMixin
extends SpellcasterIllager
implements RangedAttackMob,
IllusionerEntityAccess {
    private static final int MAX_ILLUSIONS_COUNT = 9;
    private static final int ILLUSION_LIFETIME_TICKS = 600;
    private static final int INVISIBILITY_TICKS = 60;
    private static final String IS_ILLUSION_NBT_NAME = "IsIllusion";
    private static final String WAS_ATTACKED_NBT_NAME = "WasAttacked";
    private static final String TICKS_UNTIL_DESPAWN_NBT_NAME = "TicksUntilDespawn";
    private static final String TICKS_UNTIL_CAN_CREATE_ILLUSIONS_NBT_NAME = "TicksUntilCanCreateIllusions";
    private static final EntityDataAccessor<Boolean> IS_ILLUSION = SynchedEntityData.m_135353_(IllusionerEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WAS_ATTACKED = SynchedEntityData.m_135353_(IllusionerEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TICKS_UNTIL_DESPAWN = SynchedEntityData.m_135353_(IllusionerEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TICKS_UNTIL_CAN_CREATE_ILLUSIONS = SynchedEntityData.m_135353_(IllusionerEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Illusioner illusioner = null;

    protected IllusionerEntityMixin(EntityType<? extends SpellcasterIllager> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ILLUSION, (Object)false);
        this.f_19804_.m_135372_(WAS_ATTACKED, (Object)false);
        this.f_19804_.m_135372_(TICKS_UNTIL_DESPAWN, (Object)0);
        this.f_19804_.m_135372_(TICKS_UNTIL_CAN_CREATE_ILLUSIONS, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_(IS_ILLUSION_NBT_NAME, this.isIllusion());
        nbt.m_128379_(WAS_ATTACKED_NBT_NAME, this.wasAttacked());
        nbt.m_128405_(TICKS_UNTIL_DESPAWN_NBT_NAME, this.getTicksUntilDespawn());
        nbt.m_128405_(TICKS_UNTIL_CAN_CREATE_ILLUSIONS_NBT_NAME, this.getTicksUntilCanCreateIllusions());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setIsIllusion(nbt.m_128471_(IS_ILLUSION_NBT_NAME));
        this.setWasAttacked(nbt.m_128471_(WAS_ATTACKED_NBT_NAME));
        this.setTicksUntilDespawn(nbt.m_128451_(TICKS_UNTIL_DESPAWN_NBT_NAME));
        this.setTicksUntilCanCreateIllusions(nbt.m_128451_(TICKS_UNTIL_CAN_CREATE_ILLUSIONS_NBT_NAME));
    }

    @Override
    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SpellcasterIllager.SpellcasterCastingSpellGoal((SpellcasterIllager)this));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, IronGolem.class, 8.0f, 0.6, 1.0));
        if (!this.isIllusion()) {
            this.f_21345_.m_25352_(3, (Goal)BlindTargetGoalFactory.newBlindTargetGoal((Illusioner)this));
        }
        this.f_21345_.m_25352_(4, (Goal)new RangedBowAttackGoal((Monster)this, 0.5, 20, 15.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false).m_26146_(300));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
    }

    @Override
    public void m_8119_() {
        if (!FriendsAndFoes.getConfig().enableIllusioner) {
            this.m_146870_();
        }
        super.m_8119_();
        if (this.m_183503_().m_5776_()) {
            return;
        }
        if (this.getTicksUntilCanCreateIllusions() > 0) {
            this.setTicksUntilCanCreateIllusions(this.getTicksUntilCanCreateIllusions() - 1);
        }
        if ((this.m_5448_() instanceof Player || this.m_5448_() instanceof IronGolem) && this.wasAttacked() && this.getTicksUntilCanCreateIllusions() == 0) {
            this.createIllusions();
        }
        if (this.wasAttacked() && this.m_5448_() == null && this.getTicksUntilCanCreateIllusions() < 200) {
            this.setWasAttacked(false);
            this.setTicksUntilCanCreateIllusions(0);
        }
    }

    @Override
    public void m_8107_() {
        boolean isIllusionerNonExistingOrDead;
        super.m_8107_();
        if (this.f_19853_.m_5776_() || !this.isIllusion()) {
            return;
        }
        if (this.getTicksUntilDespawn() > 0) {
            this.setTicksUntilDespawn(this.getTicksUntilDespawn() - 1);
        }
        boolean bl = isIllusionerNonExistingOrDead = this.getIllusioner() != null && !this.getIllusioner().m_6084_();
        if (this.getTicksUntilDespawn() == 0 || isIllusionerNonExistingOrDead) {
            this.discardIllusion();
        }
    }

    protected boolean m_6149_() {
        return !this.isIllusion();
    }

    protected boolean m_6125_() {
        return !this.isIllusion();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() instanceof Illusioner || this.isIllusion() && !(source.m_7639_() instanceof LivingEntity)) {
            return false;
        }
        if (this.m_183503_().m_5776_() || source.m_7639_() instanceof Player && !this.isIllusion() && ((Player)source.m_7639_()).m_150110_().f_35937_) {
            return super.m_6469_(source, amount);
        }
        if (this.isIllusion()) {
            this.discardIllusion();
            return false;
        }
        if ((source.m_7639_() instanceof Player || source.m_7639_() instanceof IronGolem) && this.getTicksUntilCanCreateIllusions() == 0) {
            this.createIllusions();
        }
        return super.m_6469_(source, amount);
    }

    private void discardIllusion() {
        this.playMirrorSound();
        this.spawnCloudParticles();
        this.m_146870_();
    }

    private void createIllusions() {
        this.setWasAttacked(true);
        this.setTicksUntilCanCreateIllusions(600);
        this.playMirrorSound();
        Vec3 illusionerPosition = this.m_20182_();
        float slice = 0.69813174f;
        int radius = 9;
        int randomPoint = RandomGenerator.generateInt(0, 8);
        for (int point = 0; point < 9; ++point) {
            boolean teleportResult;
            float angle = slice * (float)point;
            int x = (int)(illusionerPosition.m_7096_() + (double)((float)radius * Mth.m_14089_((float)angle)));
            int y = (int)illusionerPosition.m_7098_();
            int z = (int)(illusionerPosition.m_7094_() + (double)((float)radius * Mth.m_14031_((float)angle)));
            this.createIllusion(x, y, z);
            if (randomPoint != point || !(teleportResult = this.tryToTeleport(x, y, z))) continue;
            this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 60));
            this.spawnCloudParticles();
        }
    }

    private void createIllusion(int x, int y, int z) {
        Illusioner illusioner = (Illusioner)this;
        Illusioner illusion = (Illusioner)EntityType.f_20459_.m_20615_(this.f_19853_);
        illusion.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
        IllusionerEntityAccess illusionerAccess = (IllusionerEntityAccess)illusion;
        illusionerAccess.setIsIllusion(true);
        illusionerAccess.setIllusioner(illusioner);
        illusionerAccess.setTicksUntilDespawn(600);
        illusion.m_21153_(this.m_21233_());
        illusion.m_20359_((Entity)illusioner);
        illusion.m_6710_(illusioner.m_5448_());
        boolean teleportResult = illusionerAccess.tryToTeleport(x, y, z);
        if (teleportResult) {
            this.m_20193_().m_7967_((Entity)illusion);
            illusionerAccess.spawnCloudParticles();
        }
    }

    @Override
    public boolean tryToTeleport(int x, int y, int z) {
        double bottomY = Math.max(y -= 8, this.m_183503_().m_141937_());
        double topY = Math.min(bottomY + 16.0, (double)(((ServerLevel)this.m_183503_()).m_143344_() - 1));
        for (int i = 0; i < 16; ++i) {
            boolean teleportResult = this.m_20984_(x, y = (int)Mth.m_14008_((double)(y + 1), (double)bottomY, (double)topY), z, false);
            if (!teleportResult) continue;
            return true;
        }
        return false;
    }

    private void playMirrorSound() {
        this.m_5496_(SoundEvents.f_12052_, this.m_6121_(), this.m_6100_());
    }

    @Override
    public void spawnCloudParticles() {
        this.spawnParticles(ParticleTypes.f_123796_, 16);
    }

    private void spawnParticles(SimpleParticleType particleType, int amount) {
        if (this.f_19853_.m_5776_()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((ServerLevel)this.m_20193_()).m_8767_((ParticleOptions)particleType, this.m_20208_(0.5), this.m_20187_() + 0.5, this.m_20262_(0.5), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean isIllusion() {
        return (Boolean)this.f_19804_.m_135370_(IS_ILLUSION);
    }

    @Override
    public void setIsIllusion(boolean isIllusion) {
        this.f_19804_.m_135381_(IS_ILLUSION, (Object)isIllusion);
    }

    public boolean wasAttacked() {
        return (Boolean)this.f_19804_.m_135370_(WAS_ATTACKED);
    }

    public void setWasAttacked(boolean wasAttacked) {
        this.f_19804_.m_135381_(WAS_ATTACKED, (Object)wasAttacked);
    }

    @Nullable
    public Illusioner getIllusioner() {
        return this.illusioner;
    }

    @Override
    public void setIllusioner(Illusioner illusioner) {
        this.illusioner = illusioner;
    }

    public int getTicksUntilDespawn() {
        return (Integer)this.f_19804_.m_135370_(TICKS_UNTIL_DESPAWN);
    }

    @Override
    public void setTicksUntilDespawn(int ticksUntilDespawn) {
        this.f_19804_.m_135381_(TICKS_UNTIL_DESPAWN, (Object)ticksUntilDespawn);
    }

    public int getTicksUntilCanCreateIllusions() {
        return (Integer)this.f_19804_.m_135370_(TICKS_UNTIL_CAN_CREATE_ILLUSIONS);
    }

    public void setTicksUntilCanCreateIllusions(int ticksUntilCanCreateIllusions) {
        this.f_19804_.m_135381_(TICKS_UNTIL_CAN_CREATE_ILLUSIONS, (Object)ticksUntilCanCreateIllusions);
    }
}

